/*================================================================================
	
	-----------------------------------
	-*- [ZP] Zombie Flame -*-
	-----------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	Original by jtp10181, Upgraded to zp by LARP
	larp.source@gmail.com (Chile) Languaje spanish!
	
================================================================================*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <fun>
#include <zombieplague>


new smoke
new fire
new burning
new isburning[33]
//new flame_count[33]
new tkcount[33]
new gmsgDeathMsg
new gmsgScoreInfo
new bool:flame[33]

// Zombie Atributes
new const zclass_name[] = { "Flame Zombie" } // name
new const zclass_info[] = { "Health- Speed+ Gravity-" } // description
new const zclass_model[] = { "zombie_source" } // model
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" } // claw model
const zclass_health = 1300 // health
const zclass_speed = 180 // speed
const Float:zclass_gravity = 1.0 // gravity
const Float:zclass_knockback = 1.0 // knockback

// Class IDs
new g_zflame

// Zombie Classes MUST be registered on plugin_precache
public plugin_precache()
{
	fire = precache_model("sprites/explode1.spr")
	smoke = precache_model("sprites/steam1.spr")
	burning = precache_model("sprites/xfire.spr")
	precache_sound("ambience/burning1.wav")
	precache_sound("ambience/flameburst1.wav")
	precache_sound("scientist/c1a0_sci_catscream.wav")
	precache_sound("vox/_period.wav")
	precache_sound("player/headshot2.wav")
	// Register the new class and store ID for reference
	g_zflame = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)	
}

public plugin_init()
{
	register_plugin("[ZP] Zombie Flame", "1.2", "LARP")
	register_cvar("amx_flamethrower_tkpunish1", "0")
	register_cvar("amx_flamethrower_tkpunish2", "0")
	register_cvar("amx_fl_hp", "10")
	register_logevent("round_start", 2, "1=Round_Start")
	register_logevent("round_end", 2, "1=Round_End")
	register_forward(FM_PlayerPreThink,"FM_PreThink")
	
}
// User Infected forward
public zp_user_infected_post(id, infector)
{
			
	// Check if the infected player is using our custom zombie class
	if (zp_get_user_zombie_class(id) == g_zflame)
	{
		new cost = get_cvar_num("amx_fl_hp");
		fire_flamethrower(id);
		client_print(id,print_chat,"[ZP] To launch press flames +use bind. Each time you use, be reduced %d Health", cost)
		flame[id]=true
	}
	
}

/*public cmd_flamita(id)
{
	if(!is_user_alive(id) || !zp_get_user_zombie(id)) return PLUGIN_CONTINUE
	if (zp_get_user_zombie_class(id) == g_zflame)
	{
		fire_flamethrower(id)
	}
	return PLUGIN_HANDLED
}*/

fire_flamethrower(id){

		emit_sound(id, CHAN_WEAPON, "ambience/flameburst1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
		//client_cmd(id, "bind mouse3 lallamitaywea")
		new vec[3]
		new aimvec[3]
		new velocityvec[3]
		new length
		new speed = 10
		get_user_origin(id,vec)
		get_user_origin(id,aimvec,2)
		new dist = get_distance(vec,aimvec)

		new speed1 = 160
		new speed2 = 350
		new radius = 105

		if(dist < 50){
			radius = 0
			speed = 5
		}
		else if(dist < 150){
			speed1 = speed2 = 1
			speed = 5
			radius = 50
		}
		else if(dist < 200){
			speed1 = speed2 = 1
			speed = 5
			radius = 90
		}
		else if(dist < 250){
			speed1 = speed2 = 90
			speed = 6
			radius = 90
		}
		else if(dist < 300){
			speed1 = speed2 = 140
			speed = 7
		}
		else if(dist < 350){
			speed1 = speed2 = 190
			speed = 7
		}
		else if(dist < 400){
			speed1 = 150
			speed2 = 240
			speed = 8
		}
		else if(dist < 450){
			speed1 = 150
			speed2 = 290
			speed = 8
		}
		else if(dist < 500){
			speed1 = 180
			speed2 = 340
			speed = 9
		}
		else if(dist < 550){
			speed1 = 180
			speed2 = 340
			speed = 10
		}
		else if(dist < 600){
			speed1 = 250
			speed2 = 360
			speed = 11
		}
		else if(dist < 660){
			speed1 = 280
			speed2 = 390
			speed = 12
		}
		velocityvec[0]=aimvec[0]-vec[0]
		velocityvec[1]=aimvec[1]-vec[1]
		velocityvec[2]=aimvec[2]-vec[2]
		length=sqrt(velocityvec[0]*velocityvec[0]+velocityvec[1]*velocityvec[1]+velocityvec[2]*velocityvec[2])
		velocityvec[0]=velocityvec[0]*speed/length
		velocityvec[1]=velocityvec[1]*speed/length
		velocityvec[2]=velocityvec[2]*speed/length

		new args[8]
		args[0] = vec[0]
		args[1] = vec[1]
		args[2] = vec[2]
		args[3] = velocityvec[0]
		args[4] = velocityvec[1]
		args[5] = velocityvec[2]
		set_task(0.1,"te_spray",0,args,8,"a",2)
		check_burnzone(id,vec,aimvec,speed1,speed2,radius)
		//set_task(0.5,"client_bind",id)
				
		return PLUGIN_CONTINUE

}

public te_spray(args[]){

	//TE_SPRAY
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte (120) // Throws a shower of sprites or models
	write_coord(args[0]) // start pos
	write_coord(args[1])
	write_coord(args[2])
	write_coord(args[3]) // velocity
	write_coord(args[4])
	write_coord(args[5])
	write_short (fire) // spr
	write_byte (8) // count
	write_byte (70) // speed
	write_byte (100) //(noise)
	write_byte (5) // (rendermode)
	message_end()

	return PLUGIN_CONTINUE
}


public sqrt(num) {
	new div = num
	new result = 1
	while (div > result) { // end when div == result, or just below
		div = (div + result) / 2 // take mean value as new divisor
		result = num / div
	}
	return div
}

check_burnzone(id,vec[],aimvec[],speed1,speed2,radius){
	new maxplayers = get_maxplayers()+1
	new tid, tbody
	get_user_aiming(id,tid,tbody,550)
	if((tid > 0) && (tid < maxplayers)){
			burn_victim(tid,id,0)
		/*if(cvar_exists("mp_friendlyfire")){
			new ffcvar = get_cvar_num("mp_friendlyfire")
			if( (ffcvar == 0) || ((ffcvar == 1) && (get_cvar_num("amx_flamethrower_obeyffcvar") == 0)) ){
				if(get_user_team(tid) != get_user_team(id))
					burn_victim(tid,id,1)
			}
			else {
				if(get_user_team(tid) == get_user_team(id))
					burn_victim(tid,id,1)
				else
					burn_victim(tid,id,1)
			}
		}else{
			burn_victim(tid,id,0)
		}*/
	}

	new burnvec1[3],burnvec2[3],length1

	burnvec1[0]=aimvec[0]-vec[0]
	burnvec1[1]=aimvec[1]-vec[1]
	burnvec1[2]=aimvec[2]-vec[2]

	length1=sqrt(burnvec1[0]*burnvec1[0]+burnvec1[1]*burnvec1[1]+burnvec1[2]*burnvec1[2])
	burnvec2[0]=burnvec1[0]*speed2/length1
	burnvec2[1]=burnvec1[1]*speed2/length1
	burnvec2[2]=burnvec1[2]*speed2/length1
	burnvec1[0]=burnvec1[0]*speed1/length1
	burnvec1[1]=burnvec1[1]*speed1/length1
	burnvec1[2]=burnvec1[2]*speed1/length1
	burnvec1[0] += vec[0]
	burnvec1[1] += vec[1]
	burnvec1[2] += vec[2]
	burnvec2[0] += vec[0]
	burnvec2[1] += vec[1]
	burnvec2[2] += vec[2]

	new origin[3]
	for (new i=1; i<=maxplayers; i++) {
		if(cvar_exists("mp_friendlyfire")){
			new ffcvar = get_cvar_num("mp_friendlyfire")
			if( (ffcvar == 0) || ((ffcvar == 1) && (get_cvar_num("amx_flamethrower_obeyffcvar") == 0)) ){
				if(get_user_team(i) != get_user_team(id)){
					if((is_user_alive(i) == 1) && (i != id)){
						get_user_origin(i,origin)
						if(get_distance(origin,burnvec1) < radius)
							burn_victim(i,id,1)
						else if(get_distance(origin,burnvec2) < radius)
							burn_victim(i,id,1)
					}
				}

			}
			else {
				if((is_user_alive(i) == 1) && (i != id)){
					get_user_origin(i,origin)
					if(get_user_team(i) == get_user_team(id)){
						if(get_distance(origin,burnvec1) < radius)
							burn_victim(i,id,1)
						else if(get_distance(origin,burnvec2) < radius)
							burn_victim(i,id,1)
					}else{
						if(get_distance(origin,burnvec1) < radius)
							burn_victim(i,id,1)
						else if(get_distance(origin,burnvec2) < radius)
							burn_victim(i,id,1)
					}
				}
			}
		}
		else {
			if((is_user_alive(i) == 1) && (i != id)){
				get_user_origin(i,origin)
				if(get_distance(origin,burnvec1) < radius)
					burn_victim(i,id,1)
				else if(get_distance(origin,burnvec2) < radius)
					burn_victim(i,id,1)

			}
		}
	}
	return PLUGIN_CONTINUE
}

burn_victim(id,killer,tk){
	if(isburning[id] == 1)
		return PLUGIN_CONTINUE

	isburning[id] = 1

	emit_sound(id, CHAN_ITEM, "ambience/burning1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	new hp,args[4]
	hp = get_user_health(id)
	if(hp > 250)
		hp = 250
	args[0] = id
	args[1] = killer
	args[2] = tk
	set_task(0.3,"on_fire",451,args,4,"a",hp / 10)
	set_task(0.7,"fire_scream",0,args,4)
	set_task(5.5,"stop_firesound",0,args,4)

	if(tk == 1){
		new namea[32]
		get_user_name(killer,namea,31)
		new teama[32]
		get_user_team(killer,teama,31)
		new players[32],pNum
		get_players(players,pNum,"e",teama)
		for(new i=0;i<pNum;i++)
			//client_print(players[i],print_chat,"%s  attacked a teammate",namea)
			client_print(players[i],print_chat,"",namea)
		new punish1 = get_cvar_num("amx_flamethrower_tkpunish1")
		new punish2 = get_cvar_num("amx_flamethrower_tkpunish2")
		if(punish1 > 2){
			user_kill(killer,0)
			//set_hudmessage(255,50,50, -1.0, 0.45, 0, 0.02, 10.0, 1.01, 1.1, 16)
			//show_hudmessage(killer,"YOU WERE KILLED^nFOR ATTACKING TEAMMATES.^nSEE THAT IT HAPPENS NO MORE!")
			server_cmd("echo Plugin By LARP^^!", tk)
		}
		
		tkcount[killer] +=1
		if((punish1) && (tkcount[killer] > punish2 - 1)){
			if(punish1 == 1 || punish1 == 3)
				server_cmd("echo Plugin By LARP^^!")
			else if(punish1 == 2 || punish1 == 4){
				server_cmd("echo Plugin By LARP^^!")
				new authida[35]
				get_user_authid(killer,authida,34)
				if (equal("4294967295",authida)){
					new ipa[32]
					get_user_ip(killer,ipa,31,1)
					server_cmd("echo Plugin By LARP^^!")
				}else{
					server_cmd("echo Plugin By LARP^^!")
				}
			}
		}
	}
	return PLUGIN_CONTINUE
}

public on_fire(args[]){

	new hp,rx,ry,rz,forigin[3]
	new id = args[0]
	new killer = args[1]
	new tk = args[2]

	if(isburning[id] == 0)
		return PLUGIN_CONTINUE

	rx = random_num(-30,30)
	ry = random_num(-30,30)
	rz = random_num(-30,30)
	get_user_origin(id,forigin)

	//TE_SPRITE - additive sprite, plays 1 cycle
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( 17 )
	write_coord(forigin[0]+rx) // coord, coord, coord (position)
	write_coord(forigin[1]+ry)
	write_coord(forigin[2]+10+rz)
	write_short( burning ) // short (sprite index)
	write_byte( 30 ) // byte (scale in 0.1's)
	write_byte( 200 ) // byte (brightness)
	message_end()

	//Smoke
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( 5 )
	write_coord(forigin[0]+(rx*2)) // coord, coord, coord (position)
	write_coord(forigin[1]+(ry*2))
	write_coord(forigin[2]+100+(rz*2))
	write_short( smoke )// short (sprite index)
	write_byte( 60 ) // byte (scale in 0.1's)
	write_byte( 15 ) // byte (framerate)
	message_end()

	if(is_user_alive(id) == 0)
		return PLUGIN_CONTINUE

	hp = get_user_health(id)

	if((hp - 10) > 0){
		set_user_health(id,hp - 8)
	}
	else {

		new namek[32],namev[32],authida[35],authidv[35],teama[32],teamv[32]
		get_user_name(id,namev,31)
		get_user_name(killer,namek,31)
		get_user_authid(id,authidv,34)
		get_user_authid(killer,authida,34)
		get_user_team(id,teamv,31)
		get_user_team(killer,teama,31)

		//Log the Kill
		//log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"flamethrower^"",
			//namek,get_user_userid(killer),authida,teama,namev,get_user_userid(id),authidv,teamv)

		//Print message to clients
		//client_print(id,print_chat,"[AMXX] You were killed by %s's Flame Thrower",namek)
		//client_print(killer,print_chat,"[AMXX] You killed %s with your Flame Thrower",namev)
		user_kill(id,0)

		if(tk == 1){
			//client_print(killer,print_center,"You killed a teammate")
			server_cmd("echo Plugin By LARP^^!")
		}
		else{
			server_cmd("echo Plugin By LARP^^!")
		}

		//Kill the victim and block the messages
		set_msg_block(gmsgDeathMsg,BLOCK_ONCE)
		set_msg_block(gmsgScoreInfo,BLOCK_ONCE)
		user_kill(id,1)

		//Makes them stop burning
		isburning[id] = 0

		//Update killers scorboard with new info
		message_begin(MSG_ALL,gmsgScoreInfo)
		write_byte(killer)
		write_short(get_user_frags(killer))
		write_short(get_user_deaths(killer))
		write_short(0)
		write_short(get_user_team(killer))
		message_end()

		//Update victims scoreboard with correct info
		message_begin(MSG_ALL,gmsgScoreInfo)
		write_byte(id)
		write_short(get_user_frags(id))
		write_short(get_user_deaths(id))
		write_short(0)
		write_short(get_user_team(id))
		message_end()

		//Replaced HUD death message
		message_begin( MSG_ALL, gmsgDeathMsg,{0,0,0},0)
		write_byte(killer)
		write_byte(id)
		write_byte(0)
		write_string("flamethrower")
		message_end()

	}
	return PLUGIN_CONTINUE
}

public fire_scream(args[]){
	emit_sound(args[0], CHAN_AUTO, "player/headshot2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	return PLUGIN_CONTINUE
}

public stop_firesound(args[]){
	isburning[args[0]] = 0
	emit_sound(args[0], CHAN_ITEM, "vox/_period.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	return PLUGIN_CONTINUE
}

public client_connect(id){
	flame[id]=false
	return PLUGIN_CONTINUE
}

public client_disconnect(id){
	flame[id]=false
	return PLUGIN_CONTINUE
}

public round_start(id) {
	/*for (new k = 1; k <= get_maxplayers(); k++) {
		isburning[k] = 0
		new freeF = get_cvar_num("amx_flamethrower_free")
		if(freeF > 0)
			flame_count[k] = freeF
	}*/
	flame[id]=false
}
public round_end(id) {
	flame[id]=false
}



public plugin_modules()
{
	require_module("fun")
	require_module("engine")
	require_module("Counter-Strike")
	
}

public FM_PreThink(id)
{
	if(!is_user_alive(id) || !zp_get_user_zombie(id)) return PLUGIN_CONTINUE
	new fl_cost = get_cvar_num("amx_fl_hp");
	new armr = get_user_health(id);
	new nzbut = get_user_button(id)
	new ozbut = get_user_oldbutton(id)
	if((zp_get_user_zombie_class(id) == g_zflame) && (nzbut & IN_USE) && !(ozbut & IN_USE))
	//static name[32]
	if(flame[id])
	{	
		if(armr < fl_cost)
		{
			client_print(id,print_chat,"[ZP] Danger!, You will die if he continues throwing flames")
			return PLUGIN_HANDLED
		}
		set_user_health(id ,armr - fl_cost);
		fire_flamethrower(id);
	}
	else{
		if((nzbut & IN_USE) && (get_entity_flags(id) & FL_ONGROUND))
		flame[id]=false
	}
	return PLUGIN_CONTINUE
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1034\\ f0\\ fs16 \n\\ par }
*/
