#include <amxmodx>
#include <fakemeta>

#pragma semicolon 1

/*	
		[KzM] Script Detector (kzmsd) by [KzM] Fatalis
	
	This plugin detects all known bhop-scripts. If you have one that isn't detected,
	contact me.
	
	CVars:
	kzm_sd_bantime - How long the player is banned in minutes.
	kzm_sd_punishment - How to punish the player. 1=BAN 2=KICK 3=SLAY
	kzm_sd_banmode - Using AMXBans (AMXBans.net)? 1=NO 2=YES
	
	Credits:
	p3tsku for original bhop-detector
	
	http://KZMonkeys.net
	http://kzmaps-finland.net
	http://drivenservers.com
	http://xtreme-jumps.eu
	http://kzmaps.eu
	http://kz-na.com
	http://youtube.com/group/kreedz
	http;//youtube.com/user/fatalisdk
	http://kzmonkeys.net/fatalis
	http://hosted.filefront.com/fatalisdk
	
	KZMonkeys Servers:
	KZ - 8.9.22.42:27017
	Hide-n-Seek - 208.68.170.141:27015
	BunnyHop - 75.126.118.18:27015
	Surf - 208.68.170.188:27015
	
	AIM: FatalisDK
	MSN: FatalisDK@hotmail.com
	YAHOO: FatalisDK
	IRC: [KzM]Fatalis @ GameSurge, QuakeNet, Freenode
	
	irc.gamesurge.net:
	#KZMonkeys
	#DrivenServers
	
	irc.quakenet.org:
	#KZMonkeys
	#kzmaps.fi
	#xtreme-jumps
	#kzmaps
	#kz-na
	
	PayPal Donate: fatalisdk@yahoo.com
*/

new const gPLUGIN[] = "[KzM] Script Detector";
new const gVERSION[] = "1.1";
new const gAUTHOR[] = "[KzM] Fatalis";

new const gLOOPTYPES[][] =
{
	"special",
	"rebuy",
	"autobuy"
};

new gRandomStrings[3][4];
new gAliases[129];

new gMsgSayText;
new gMaxPlayers;

new gTimesDetected[33];

new gCvarBanTime;
new gCvarPunishment;
new gCvarBanMode;

public plugin_init()
{
	register_plugin(gPLUGIN, gVERSION, gAUTHOR);
	
	register_cvar("fatalis", "sd1.1", FCVAR_SERVER, 0.0);
	
	gMsgSayText = get_user_msgid("SayText");
	gMaxPlayers = get_maxplayers();
	
	gCvarBanTime = register_cvar("kzm_sd_bantime", "30", 0, 0.0);
	gCvarPunishment = register_cvar("kzm_sd_punishment", "1", 0, 0.0);
	gCvarBanMode = register_cvar("kzm_sd_banmode", "1", 0, 0.0);
	
	register_forward(FM_PlayerPreThink, "fwdPlayerPreThink", 0);
	
	new szCmd[10] = "kzm_sd";
	for( new i = 6; i < 10; i++ )
	{
		szCmd[i] = random_num('a', 'z');
	}
	
	register_clcmd(szCmd, "cmdScriptDetected", -1, "");
	
	for( new i = 0; i < 3; i++ )
	{
		for( new j = 0; j < 3; j++ )
		{
			gRandomStrings[i][j] = random_num('a', 'z');
		}
	}
	
	format(gAliases, 128,
		";alias cl_yawspeed say LJScript;alias _special %s %s;alias cl_rebuy %s %s;alias cl_autobuy %s %s",
		szCmd, gRandomStrings[0],
		szCmd, gRandomStrings[1],
		szCmd, gRandomStrings[2]);
	
	return PLUGIN_CONTINUE;
}

public fwdPlayerPreThink(plr)
{
	if( pev(plr, pev_button)&IN_JUMP
	&& !(pev(plr, pev_oldbuttons)&IN_JUMP) )
	{
		client_cmd(plr, gAliases);
	}
	
	return FMRES_IGNORED;
}

public client_putinserver(plr)
{
	gTimesDetected[plr] = 0;
	
	return PLUGIN_CONTINUE;
}

public cmdScriptDetected(plr)
{
	if( !is_user_alive(plr)
	|| fnIsOnGround(plr) )
	{
		return PLUGIN_HANDLED;
	}
	
	new szArg[7];
	read_argv(1, szArg, 6);
	
	for( new i = 0; i < 3; i++ )
	{
		if( !strcmp(szArg, gRandomStrings[i], 0) )
		{
			switch( i )
			{
			case 0:
			{
				fnPunish(plr, i);
			}
			case 1,2:
			{
				switch( ++gTimesDetected[plr] )
				{
				case 1,2:
				{
					fnGreenChat(plr, "[KzMSD] Don't use rebuy/autobuy on this server.");
				}
				case 3:
				{
					fnPunish(plr, i);
					gTimesDetected[plr] = 0;
				}
				}
			}
			}
			
			break;
		}
	}
	
	return PLUGIN_HANDLED;
}

bool:fnIsOnGround(plr) // surf_olympics.sma - OneEyed
{	
	new flags = pev(plr, pev_flags);
	
	if( (flags&FL_ONGROUND) || (flags & FL_PARTIALGROUND)
	||( flags&FL_INWATER )
	||( flags&FL_CONVEYOR )
	||( flags&FL_FLOAT) )
	{
		return true;
	}
	
	return false;
}

fnGreenChat(plr, const message[], {Float,Sql,Result,_}:...)
{
	static msg[192];
	msg[0] = 0x04;
	
	vformat(msg[1], 190, message, 3);
	
	if( plr > 0 && plr <= gMaxPlayers )
	{
		message_begin(MSG_ONE, gMsgSayText, {0, 0, 0}, plr);
		write_byte(plr);
		write_string(msg);
		message_end();
	}
	else if( plr == 0 )
	{
		for( new i = 1; i <= gMaxPlayers; i++ )
		{
			if( !is_user_connected(i) )
			{
				continue;
			}
			
			message_begin(MSG_ONE, gMsgSayText, {0, 0, 0}, i);
			write_byte(i);
			write_string(msg);
			message_end();
		}
	}
	
	return 1;
}

fnPunish(plr, loopType)
{
	new banTime = get_pcvar_num(gCvarBanTime);
	new punishment = get_pcvar_num(gCvarPunishment);
	new banMode = get_pcvar_num(gCvarBanMode);
	new userId = get_user_userid(plr);
	
	new szName[32];
	get_user_name(plr, szName, 32);
	
	new szReason[33];
	format(szReason, 32, "Script(%s)", gLOOPTYPES[loopType]);
	
	switch( punishment )
	{
	case 1:
	{
		if( banMode == 1 )
		{
			server_cmd("amx_ban #%i %i ^"%s^"", userId, banTime, szReason);
		}
		else if( banMode == 2 )
		{
			server_cmd("amx_ban %i #%i %s", banTime, userId, szReason);
		}
		
		fnGreenChat(0, "[KzMSD] %s was automagically banned for %i minutes. Reason: %s",
			szName, banTime, szReason);
	}
	case 2:
	{
		server_cmd("amx_kick #%i ^"%s^"", userId, szReason);
		
		fnGreenChat(0, "[KzMSD] %s was automagically kicked. Reason: %s", szName, szReason);
	}
	case 3:
	{
		user_kill(plr, 0);
		
		fnGreenChat(0, "[KzMSD] %s was automagically slayed. Reason: %s", szName, szReason);
	}
	}
	
	
	return 1;
}

// Q-ba11 is a homosexual.
