#include <amxmodx>
#include <fakemeta>

// Copyright
#define PLUGIN "HP Autoheal"
#define VERSION "1.4"
#define AUTHOR "AciD"

// Defines
#define TASKID 100
#define SOUND1 "misc/hp/1.wav"

// Cvars
new hp_reg,hp_regtime,hp_showdmg,hp_screenfade,hp_fade_r,hp_fade_g,hp_fade_b,hp_fade_a,hp_sounds

// Misc
new plrHeal[33]
new gmsgScreenFade

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_cvar("AcidoX", "Autoheal 1.4", FCVAR_SERVER)
	register_event("Damage", "damage", "b", "2>0")
	
	hp_reg = register_cvar("hp_reg", "60")
	hp_regtime = register_cvar("hp_regtime", "0.5")
	hp_showdmg = register_cvar("hp_showdmg", "1")
	hp_screenfade = register_cvar("hp_screenfade", "1")
	hp_fade_r = register_cvar("hp_fade_r", "200")
	hp_fade_g = register_cvar("hp_fade_g", "0")
	hp_fade_b = register_cvar("hp_fade_b", "0")
	hp_fade_a = register_cvar("hp_fade_a", "65")
	hp_sounds = register_cvar("hp_sounds", "1")
	
	gmsgScreenFade = get_user_msgid("ScreenFade")
}

public damage(id)
{
	new dmg = read_data(2)
	
	if(read_data(4) != 0 || read_data(5) != 0 || read_data(6) != 0) return
	
	if((get_pcvar_num(hp_showdmg) == 1) && dmg < 100) {
	new msg[32]
	formatex(msg, 31, "Damage: %i", dmg)
	set_hudmessage(255, 0, 0, 0.05, 0.9, 0, 2.0, 2.0, 0.2)
	show_hudmessage(id, msg)
	
	if((get_pcvar_num(hp_sounds) == 1) && dmg < 100) {
		client_cmd(id, "speak %s", SOUND1)
	}
}
	plrHeal[id] += dmg
	
	if(!task_exists(TASKID + id))
	{
		set_task(get_pcvar_float(hp_regtime), "tsk_heal", id + TASKID)
		
		if((get_pcvar_num(hp_screenfade) == 1) && dmg < 100) {

		message_begin(MSG_ONE, gmsgScreenFade, _, id)
		write_short(1<<10)
		write_short(1<<10)
		write_short(0x0000)
		write_byte(get_pcvar_num(hp_fade_r))
		write_byte(get_pcvar_num(hp_fade_g))
		write_byte(get_pcvar_num(hp_fade_b))
		write_byte(get_pcvar_num(hp_fade_a))
		message_end()
		}
	}
}


public tsk_heal(id)
{
	id -= TASKID
	
	if(plrHeal[id] == 0) return
	if(!is_user_alive(id))
	{
		plrHeal[id] = 0
		return
	}
	new hp_reg2 = get_pcvar_num(hp_reg);
	new hp = pev(id, pev_health)
	
	plrHeal[id] > hp_reg2 ? (plrHeal[id] = hp_reg2) : 0
	
	if(hp + plrHeal[id] > 100)
	{
		plrHeal[id] = 0
		return
	}

	set_pev(id, pev_health, float(hp + plrHeal[id]))
	plrHeal[id] = 0
	
	return
}

public plugin_precache() 
{
		precache_sound(SOUND1)
}

public plugin_cfg() 
{
	new cfg[128]
	format(cfg, 127, "%s/autoheal.cfg", cfg)
	if (file_exists(cfg))
	{
		server_exec()
		server_cmd("exec %s", cfg)
	}
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1049\\ f0\\ fs16 \n\\ par }
*/
