/* VIPSystem v1.4 */

#include <amxmodx>
#include <hamsandwich>

#define VIP_STEAM 	(1<<0)
#define VIP_IP 		(1<<1)
#define VIP_NAME 	(1<<2)

new const fileName[] = "vips.ini";

new Array:vipAuthArray;
new Array:vipPasswordArray;
new Array:vipAccessArray;
new Array:vipFlagsArray;
new vipsNumber = 0;

new cvarPasswordField;

new forwardVipConnect, result;

new bool:vip[33], vipFlags[33];

new letter[26] = {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
new currentDate[9], maxPlayers;

public plugin_init() 
{
	register_plugin("VIPSystem", "1.4", "ZETA [M|E|N]");
	
	register_dictionary("VIPSystem.txt");
	
	cvarPasswordField = register_cvar("vs_password_field", "_pw");
	
	forwardVipConnect = CreateMultiForward("VSVipConnect", ET_CONTINUE, FP_CELL);
	
	get_time("%d.%m.%y", currentDate, charsmax(currentDate));
	maxPlayers = get_maxplayers();
	
	new configsDir[64];
	get_localinfo("amxx_configsdir", configsDir, charsmax(configsDir));
	server_cmd("exec %s/vips.cfg", configsDir);
	
	LoadVipList();
	
	register_concmd("vips_list", "ShowVipsList", ADMIN_ALL, "Show Vips List");
	register_clcmd("addvip", "AddVip", ADMIN_ALL, "Add Vip");
}

public plugin_precache()
{
	vipAuthArray = ArrayCreate(44, 1);
	vipPasswordArray = ArrayCreate(32, 1);
	vipFlagsArray = ArrayCreate(1, 1);
	vipAccessArray = ArrayCreate(1, 1);
}

FindFlag(const arr[], const ch)
{
	new size = strlen(arr);
	for (new i = 0; i < size; i++)
	{
		if (arr[i] == ch)
		{
			return true;
		}
	}
	
	return false;
}

ReadAccessFlags(const str[])
{
	new flagsBin = 0;
	for (new i = 0; i < 26; i++)
	{
		if (FindFlag(str, letter[i]))
		{
			flagsBin |= (1<<i);
		}
	}

	return flagsBin;
}

ReadAccountFlags(const str[])
{
	new accBin = 0;
	for (new i = 0; i < 3; i++)
	{
		if (FindFlag(str, letter[i]))
		{
			accBin |= (1<<i);
		}
	}
	
	return accBin;
}

LoadVip(const auth[], const pass[], const acc[], const flags[])
{
	ArrayPushString(vipAuthArray, auth);
	ArrayPushString(vipPasswordArray, pass);
	ArrayPushCell(vipAccessArray, ReadAccessFlags(acc));
	ArrayPushCell(vipFlagsArray, ReadAccountFlags(flags));
}

LoadVipList()
{
	new path[64];
	get_localinfo("amxx_configsdir", path, charsmax(path));
	format(path, charsmax(path), "%s/%s", path, fileName);
	
	new file = fopen(path, "r+");
	
	if (!file)
	{
		log_to_file("VIPSystem.txt", "LoadVipList(): %L", LANG_SERVER, "NO_FILE", path);
		return;
	}
	
	new text[121], auth[44], pass[32], acc[26], flags[3], expiredDate[9], pos;
	while (!feof(file))
	{
		pos = ftell(file);
		fgets(file, text, charsmax(text));
		
		trim(text);
		
		if ((text[0] == ';') || !strlen(text)) 
		{ 
			continue; 
		}
		
		if (parse(text, auth, charsmax(auth), pass, charsmax(pass), acc, charsmax(acc), flags, charsmax(flags), expiredDate, charsmax(expiredDate)) != 5)
		{
			log_to_file("VIPSystem.txt", "LoadVipList(): %L", LANG_SERVER, "INVALID_FORMAT", text);
			continue;
		}
		
		if (equal(currentDate, expiredDate))
		{
			fseek(file, pos, SEEK_SET); 
			fprintf(file, ";%s", text);
			fseek(file, 0, SEEK_CUR);
			continue;
		}
			
		LoadVip(auth, pass, acc, flags);
		++vipsNumber;
	}
		
	fclose(file);
	
	switch (vipsNumber)
	{
		case 0: server_print("[VIPSystem] %L", LANG_SERVER, "NO_VIPS");
		case 1: server_print("[VIPSystem] %L", LANG_SERVER, "LOADED_VIP");
		default: server_print("[VIPSystem] %L", LANG_SERVER, "LOADED_VIPS", vipsNumber);
	}
}

RemoveAccess(const id)
{
	vip[id] = false;
	vipFlags[id] = 0;
}

GetAccess(const id)
{
	new userName[32], passField[32], userPass[32], userAuth[32], userIp[44];
	get_user_info(id, "name", userName, charsmax(userName));
	get_pcvar_string(cvarPasswordField, passField, charsmax(passField));
	get_user_info(id, passField, userPass, charsmax(userPass));
	get_user_authid(id, userAuth, charsmax(userAuth));
	get_user_ip(id, userIp, charsmax(userIp), 1);
	
	RemoveAccess(id);
	
	new auth[44], pass[32], acc, flags;
	for (new i = 0; i < vipsNumber; i++)
	{
		ArrayGetString(vipAuthArray, i, auth, charsmax(auth));
		ArrayGetString(vipPasswordArray, i, pass, charsmax(pass));
		acc = ArrayGetCell(vipAccessArray, i);
		flags = ArrayGetCell(vipFlagsArray, i);
		
		if (((flags & VIP_STEAM) && equal(auth, userAuth)) || ((flags & VIP_IP) && equal(auth, userIp)))
		{
			vip[id] = true;
			vipFlags[id] = acc;
			break;
		}
		else if ((flags & VIP_NAME) && equal(auth, userName))
		{
			if (equal(pass, userPass))
			{
				vip[id] = true;
				vipFlags[id] = acc;
			}
			else
			{
				server_cmd("kick #%d ^"You have no entry to the server...^"", get_user_userid(id));
			}
			
			break;
		}
	}
}

ConnectGetAccess(const id)
{
	GetAccess(id);
	
	if (vip[id])
	{
		ExecuteForward(forwardVipConnect, result, id);
	}
}

// Events

public client_putinserver(id)
{
	ConnectGetAccess(id);
}

public client_disconnect(id)
{
	RemoveAccess(id);
}

public client_infochanged(id)
{
	new newname[32], oldname[32];
	get_user_name(id, oldname, charsmax(oldname));
	get_user_info(id, "name", newname, charsmax(newname));
	
	if (!equal(newname, oldname))
	{
		GetAccess(id);
	}
}

// Natives

public plugin_natives()
{	
	register_native("VSGetUserVip", "NativeGetUserVip", 1);
	register_native("VSGetVipFlag", "NativeGetVipFlag", 1);
	register_native("VSGetVipFlags", "NativeGetVipFlags", 1);
}

public NativeGetUserVip(id)
{
	if (!IsUser(id))
	{
		log_to_file("VIPSystem.txt", "NativeGetUserVip(id): %L", LANG_SERVER, "OUT_OF_RANGE", id);
		return false;
	}
	
	return vip[id];
}

public NativeGetVipFlag(id, flag)
{
	if (!IsUser(id))
	{
		log_to_file("VIPSystem.txt", "NativeGetVipFlag(id, flag): %L", LANG_SERVER, "OUT_OF_RANGE", id);
		return false;
	}
	
	if (!vip[id])
	{
		return false;
	}
	
	if (flag && !(vipFlags[id] & flag))
	{
		return false;
	}
	
	return true;
}

public NativeGetVipFlags(id)
{
	if (!IsUser(id))
	{
		log_to_file("VIPSystem.txt", "NativeGetVipFlags(id): %L", LANG_SERVER, "OUT_OF_RANGE", id);
		return 0;
	}
	
	return vipFlags[id];
}

// Commands

public ShowVipsList(id)
{
	if (id)
	{
		client_print(id, print_console, "Unknown command: vips_list");
		return PLUGIN_HANDLED;
	}
	
	new auth[44], pass[32], accBin, flagsBin, acc[26], flags[3];
	server_print("%L", LANG_SERVER, "VIPS_LIST");
	
	if (!vipsNumber)
	{
		server_print("%L", LANG_SERVER, "NO_VIPS");
		return PLUGIN_HANDLED;
	}
	
	for(new i = 0; i < vipsNumber; i++)
	{
		ArrayGetString(vipAuthArray, i, auth, charsmax(auth));
		ArrayGetString(vipPasswordArray, i, pass, charsmax(pass));
		accBin = ArrayGetCell(vipAccessArray, i);
		flagsBin = ArrayGetCell(vipFlagsArray, i);
		
		format(acc, charsmax(acc), "");
		for (new i = 0, len = 0; i < 26; i++)
		{
			if (accBin & (1<<i))
			{
				strcat(acc, letter[i], ++len);
			}
		}
		
		format(flags, charsmax(flags), "");
		for (new i = 0, len = 0; i < 3; i++)
		{
			if (flagsBin & (1<<i))
			{
				strcat(flags, letter[i], ++len);
			}
		}
		
		server_print("^"%s^" ^"%s^" ^"%s^" ^"%s^"", auth, pass, acc, flags);
	}
	
	return PLUGIN_HANDLED;
}

public AddVip(id)
{
	if (!(get_user_flags(id) & ADMIN_CVAR))
	{
		client_print(id, print_console, "%L", id, "NO_ACC_COM");
		return PLUGIN_HANDLED;
	}
	
	new text[121], auth[44], pass[32], flags[26], acc[3] , vipEndDate[8];
	read_args(text, charsmax(text));

	if (parse(text, auth, charsmax(auth), pass, charsmax(pass), acc, charsmax(acc), flags, charsmax(flags), vipEndDate, charsmax(vipEndDate)) != 5)
	{
		client_print(id, print_console, "%L", LANG_SERVER, "FORMAT_ADD");
		return PLUGIN_HANDLED;
	}
	
	new path[64];
	get_localinfo("amxx_configsdir", path, charsmax(path));
	format(path, charsmax(path), "%s/%s", path, fileName);
	
	new file = fopen(path, "a");
	
	if (file)
	{
		fseek(file, 0, SEEK_END);
		fprintf(file, "^n^"%s^" ^"%s^" ^"%s^" ^"%s^" ^"%s^"", auth, pass, acc, flags, vipEndDate);
		fclose(file);
	}
			
	LoadVip(auth, pass, flags, acc);
	client_print(id, print_console, "[VIPSystem] %L", LANG_SERVER, "VIP_ADDED");
	return PLUGIN_HANDLED;
}

// Other

public IsUser(id)
{
	return (1 <= id <= maxPlayers);
}

public plugin_end()
{
	ArrayDestroy(vipAuthArray);
	ArrayDestroy(vipPasswordArray);
	ArrayDestroy(vipFlagsArray);
	ArrayDestroy(vipAccessArray);
}
